package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;

import java.util.HashSet;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dto.UserApproverDTO;
import gov.va.genisis2.model.UserApprover;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 * 
 */

public class UserApproverConverterTest extends AbstractMockMvcTests {

	/** The userApproverConverter. */
	private UserApproverConverter userApproverConverter;

	/** Run before all test methods. */
	@Before
	public void setUp() {
		userApproverConverter = new UserApproverConverter();
		userApproverConverter.setUserConverter(getMockUserConverter());
	}

	/** To test Convert method */
	@Test
	public void testConvert() {
		UserApproverDTO userApproverDto = userApproverConverter.convert(Helper.getNewUserApprover());
		assertEquals(1, userApproverDto.getId());

		userApproverDto = userApproverConverter.convert(Helper.getNewUserApprover1());
		assertEquals(2, userApproverDto.getId());
	}

	/** To test ConvertUserApprovers method */
	@Test
	public void testConvertUserApprovers() {
		userApproverConverter.convertUserApprovers(new HashSet<UserApprover>(0));
		
		Set<UserApprover> userApproverDtoList = new HashSet<UserApprover>(0);
		userApproverDtoList.add(Helper.getNewUserApprover());
		Set<UserApproverDTO> userApproverDto = userApproverConverter.convertUserApprovers(userApproverDtoList);
		assertEquals(1, userApproverDto.size());
	}

	/** To test convertWithoutUser method */
	@Test
	public void testConvertWithoutUser() {
		UserApproverDTO userApproverDto = userApproverConverter.convertWithoutUser(Helper.getNewUserApprover());
		assertEquals(1, userApproverDto.getId());
	}

}
